/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.pki.OraclePKIProvider;

public final class LDAPJSSESocketFactoryImpl
extends SocketFactory {
    public static final String WALLET_LOCATION = "oracle.ldap.wltloc";
    public static final String WALLET_PASSWORD = "oracle.ldap.wltpass";
    private static SSLSocketFactory sslf = null;

    public LDAPJSSESocketFactoryImpl() throws Exception {
        this(System.getProperties());
    }

    public LDAPJSSESocketFactoryImpl(Hashtable hashtable) throws Exception {
        block3: {
            Security.insertProviderAt((Provider)new OraclePKIProvider(), 1);
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12", "OraclePKI");
                String string = (String)hashtable.get(WALLET_PASSWORD);
                String string2 = (String)hashtable.get(WALLET_LOCATION);
                if (string == null && string2 == null) {
                    SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                    sSLContext.init(null, null, null);
                    sslf = sSLContext.getSocketFactory();
                    break block3;
                }
                this.ckWltLoc((String)hashtable.get(WALLET_LOCATION));
                FileInputStream fileInputStream = new FileInputStream((String)hashtable.get(WALLET_LOCATION));
                keyStore.load(fileInputStream, string.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
                keyManagerFactory.init(keyStore, string.toCharArray());
                KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                sslf = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                System.out.println("Exception while trying to connect:" + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static SocketFactory getDefault() {
        try {
            return new LDAPJSSESocketFactoryImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)sslf.createSocket(string, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)sslf.createSocket(inetAddress, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)sslf.createSocket(string, n, inetAddress, n2);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)sslf.createSocket(inetAddress, n, inetAddress2, n2);
        return this.init(sSLSocket);
    }

    private SSLSocket init(SSLSocket sSLSocket) throws IOException {
        String[] stringArray = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledCipherSuites(stringArray);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private void ckWltLoc(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("The wallet \"" + string + "\" does not exist.");
        }
        if (!file.canRead()) {
            throw new IOException("The wallet \"" + string + "\" cannot be read.");
        }
        if (!file.isFile()) {
            throw new IOException("The wallet \"" + string + "\" is not a 'normal' file.");
        }
    }
}

